<?php

include_once 'config.php';

use LearnositySdk\Request\Init;

$request = [
    'reports' => [
        [
            'id'           => 'sessions-list',
            'type'         => 'sessions-list',
            'limit'        => 15,
            'activities'   => [
                [
                    "id"   => "Summer_Test_1",
                    "name" => "Summer Test 1, 2015"
                ]
            ],
            'render'       => false
        ]
    ]
];

$Init = new Init('reports', $security, $consumer_secret, $request);
$signedRequest = $Init->generate();

?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <title>Report: Session Detail by Question</title>
        <style>
            .learnosity-report * {
               font-family:Courier,monospace !important;
            }
            .preview pre {
               background-color: #F8F8FF;
               border: 1px solid #C0C0C0;
               padding: 10px 20px;
               margin: 20px;
               display:none;
            }
            .preview .json-key {
               color: #A52A2A;
            }
            .preview .json-value {
               color: #000080;
            }
            .preview .json-string {
               color: #808000;
            }

            .avg {
                height:20px;
                background-color:#0000CC;
                margin:20px;
                opacity:0;
            }
            #avgScore, #avgScore span {
                font-family:Arial,sans-serif !important;
                font-size:18pt;
                margin-left:20px;
            }
        </style>
    </head>
    <body>
        <div style="width:750px;">
            <div id="avgScore">Session Average Score: 
                <span id="avgScorePercent"></span>
            </div>
            <div class="avg"></div>
            <div class="previewWrapper preview">
                <pre><code></code></pre>
            </div>
        </div>

        <script src="//ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
        <script src="js/prettyPrint.js"></script>
        <script src="//reports.learnosity.com"></script>
        <script>
            var eventOptions = {
                readyListener: function () {
                    var sessionsReport = reportsApp.getReport("sessions-list");

                    sessionsReport.on("load:data", function (data) {
                        var avgSum = 0;
                        $.each(data.sessions, function(index, value) {
                            avgSum += parseFloat(value.count_score_correct)/parseFloat(value.count_score);
                        });
                        var avg = (avgSum/data.sessions.length);
                        var avgPercent = Math.round(avg*100*100)/100;
                        var avgWidth = $(".avg").width();
                        $(".avg").animate({width:0},0)
                                 .animate({width:avg*avgWidth, opacity:1}, 1000,
                                    function(){
                                        $("#avgScorePercent").html(avgPercent + "%");
                                    });

                        $("code").html(
                            prettyPrint.render(data)
                        );
                        $(".preview pre").show();
                    });
                }
            }
            var reportsApp = LearnosityReports.init(<?php echo $signedRequest; ?>, eventOptions);
        </script>
    </body>
</html>