<?php

include_once 'config.php';

use LearnositySdk\Request\Init;
use LearnositySdk\Utils\Uuid;

$request = [
  'user_id'        => 'demo_student',
  'session_id'     => Uuid::generate(),
  'items'          => ['act1','act2','act3','act4','act5','act6'],
  'rendering_type' => 'inline',
  'state'          => 'initial',
  'type'           => 'submit_practice',
  'activity_id'    => 'demo_activity',
  'name'           => 'The Color Wheel',
  'course_id'      => 'demo_course',
  'config'         => [
      'renderSubmitButton'  => true
  ]
];

$Init = new Init('items', $security, $consumer_secret, $request);
$signedRequest = $Init->generate();

?>

<!DOCTYPE html>
<html lang='en'>
  <head>
    <meta charset='utf-8'>
    <title>Hints Tutorial</title>
    <style>
      body {
        background-color:#F2F2F2;
      }
      .learnosity-item {
        background-color:#FFFFFF;
        padding:20px;
        margin:20px 0px;
      }
      .distractor {
        margin-top:5px;
        padding:10px;
        background-color:#EBCCD1;
        color:#b94a48;
      }
      .hint {
        margin-top:5px;
        padding:10px;
        background-color:#EEFFFF;
      }
      input[type='text'] {
        width:100px !important;
      }
    </style>
  </head>
  <body>
    <h1>Hints Tutorial</h1>
    <div style='width:750px;'>
      <span class='learnosity-item' data-reference='act1'></span>
      <span class='learnosity-item' data-reference='act2'></span>
      <span class='learnosity-item' data-reference='act3'></span>
      <span class='learnosity-item' data-reference='act4'></span>
      <span class='learnosity-item' data-reference='act5'></span>
      <span class='learnosity-item' data-reference='act6'></span>
      <span class='learnosity-submit-button'></span>
    </div>

    <script src='//ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js'></script>
    <script src='//items.learnosity.com/'></script>
    <script>

      var responseIDHints = {};

      var eventOptions = {
        readyListener: function () {

          $.each(itemsApp.questions(), function(responseID, question) {

            responseIDHints[responseID] = question.getMetadata().hint;

            var btnHint = '<button type="button" class="btn btn-default btn-sm" data-responseid="' + responseID + '">Hint</button>';
            $('#' + responseID).append(btnHint);

            $("button").click(function() {
              renderHint($(this));
            });

            question.on("changed", function(){
              $("#" + responseID + "_hint").fadeOut();
            });

          });

        }
      }

      function renderHint(whichBtn) {
        var responseID = whichBtn.data("responseid");

        var hint = responseIDHints[responseID];

        if ($("#" + responseID + "_hint").length) {
            $("#" + responseID + "_hint").html(hint).fadeIn();
        } else {
            $("#" + responseID).append('<div id="' + responseID + '_hint" class="hint">' + hint + '</div>').fadeIn();
        }

        MathJax.Hub.Queue([
          "Typeset", MathJax.Hub, responseID
        ]);
      }

      var itemsApp = LearnosityItems.init(<?php echo $signedRequest; ?>, eventOptions);
    </script>
  </body>
</html>