<?php

include_once 'config.php';

use LearnositySdk\Request\Init;
use LearnositySdk\Utils\Uuid;

$request = [
  'user_id'        => 'demo_student',
  'session_id'     => Uuid::generate(),
  'items'          => ['act1','act2','act3','act4','act5','act6'],
  'rendering_type' => 'inline',
  'state'          => 'initial',
  'type'           => 'submit_practice',
  'activity_id'    => 'demo_activity',
  'name'           => 'The Color Wheel',
  'course_id'      => 'demo_course',
  'config'         => [
      'renderSubmitButton'  => true
  ]
];

$Init = new Init('items', $security, $consumer_secret, $request);
$signedRequest = $Init->generate();

?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <title>Distractor Rationale</title>
    <style>
      body { 
        background-color:#F2F2F2; 
      }
      .learnosity-item { 
        background-color:#FFFFFF; 
        padding:20px; 
        margin:20px 0px;
      }
      .distractor { 
        margin-top:5px;
        padding:10px;
        background-color:#EBCCD1;
        color:#b94a48; 
      }
    </style>
  </head>
  <body>
    <h1>Distractor Rationale Tutorial</h1>
    <div>
      <span class="learnosity-item" data-reference="act1"></span>
      <span class="learnosity-item" data-reference="act2"></span>
      <span class="learnosity-item" data-reference="act3"></span>
      <span class="learnosity-item" data-reference="act4"></span>
      <span class="learnosity-item" data-reference="act5"></span>
      <span class="learnosity-item" data-reference="act6"></span>
      <span class="learnosity-submit-button"></span>
    </div>

    <script src="//ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
    <script src="//items.learnosity.com/"></script>
    <script>

      var eventOptions = {

        readyListener: function () {
          $.each(itemsApp.questions(), function(responseID, question) {

            question.on("validated", function() {
              if (question.isValid()) { return; }

              var outputHTML = "";

              if (question.getResponse().type != "array") {
                outputHTML = '<span class="incorrectText">' + question.getMetadata().distractor_rationale + '</span>';
              } else {
                var map = question.mapValidationMetadata("distractor_rationale_response_level");

                $.each(map.incorrect, function (i, data) {
                  outputHTML += '<li class="incorrectText">' + data.metadata + '</li>';
                });
                if (outputHTML != "") { outputHTML = "<ul>" + outputHTML + "</ul>"; }
              }

              if (outputHTML == "") { outputHTML = "Have you answered all possible responses?"; }

              if ($("#" + responseID + "_distractor").length) {
                  $("#" + responseID + "_distractor").html(outputHTML).fadeIn();
              } else {
                  $("#" + responseID).append('<div id="' + responseID + '_distractor" class="distractor">' + outputHTML + '</div>');
              }
              MathJax.Hub.Queue([
                "Typeset", MathJax.Hub, responseID
              ]);

            });

            question.on("changed", function (responseID, question) {
              $("#" + this.getQuestion().response_id + "_distractor").fadeOut();
            });

          });

        }
      }

      var itemsApp = LearnosityItems.init(<?php echo $signedRequest; ?>, eventOptions);
    </script>
  </body>
</html>