<?php

include_once 'config.php';

use LearnositySdk\Request\Init;
use LearnositySdk\Utils\Uuid;

$request = array(
  'user_id'        => 'demo_student',
  'session_id'     => Uuid::generate(),
  'items'          => ['act1','act2','act3','act4','act5','act6'],
  'rendering_type' => 'inline',
  'state'          => 'initial',
  'type'           => 'submit_practice',
  'activity_id'    => 'demo_activity',
  'name'           => 'Question-Level Events and Public Methods',
  'course_id'      => 'demo_course',
);

$Init = new Init('items', $security, $consumer_secret, $request);
$signedRequest = $Init->generate();

?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <title>Question-Level Events and Public Methods</title>
    <style>
      body { 
        background-color:#F2F2F2; 
      }
      .learnosity-item { 
        background-color:#FFFFFF; 
        padding:20px; 
        margin:20px 0px;
      }
      .score { 
        margin-top:5px;
        padding:10px;
        background-color:#FDF8D2;
      }
      #customBtns {
        float:right;
        margin:0px 20px 20px 0px;
      }
      button {
        margin-left:20px;
      }
    </style>
  </head>
  <body>
    <h1>Question-Level Events and Public Methods Snippets</h1>
    <div style="width:750px;">
      <span class="learnosity-item" data-reference="act1"></span>
      <span class="learnosity-item" data-reference="act2"></span>
      <span class="learnosity-item" data-reference="act3"></span>
      <span class="learnosity-item" data-reference="act4"></span>
      <span class="learnosity-item" data-reference="act5"></span>
      <span class="learnosity-item" data-reference="act6"></span>
      <p id="customBtns"><button id="validateBtn">Validate</button><button id="submitBtn">Submit</button></p>
    </div>

    <script src="//ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
    <script src="//items.learnosity.com/"></script>
    <script>

      var eventOptions = {

        readyListener: function () {

          $.each(itemsApp.questions(), function(responseID, question) {



            //Snippet 1: Viewing Question and Response Data
            question.once('validated', showQuestionAndResponse);
            function showQuestionAndResponse() {
              console.log("question", question.getQuestion());
              console.log("response", question.getResponse());
            }
            
            
            
            //Snippet 2: Show Score Upon Validation
            question.on('validated', showScore);

            function showScore() {
              var score = question.getScore();
              var scoreString = (question.isValid()) ? "Contratulations! " : "";
              scoreString += "Score: " + score.score + " of " + score.max_score;

              var meta = question.getMetadata();
              var item = $(".learnosity-item[data-reference=" + meta.sheet_reference + "]");
              var scoreDiv = item.find("div.score");
              
              if (scoreDiv.length) {
                scoreDiv.html(scoreString);
              } else {
                item.append('<div class="score">' + scoreString + '</div>');
              }

              //question.off('validated', showScore);
            }
          });

        }
      }
      
      

      //Snippet 3: Confirming that All Questions are Attempted Before Submitting
      function allAttempted() {
        var allQuestionsAttempted = true;
        $.each(itemsApp.questions(), function( responseID, question ) {
          if (!question.isAttempted()) {
            allQuestionsAttempted = confirm("One or more questions have not been attempted. Are you sure you want to submit?");
            return false;
          }
        });
        return allQuestionsAttempted;
      }

      var submitSettings = {
        success: function (response_ids) {
          console.log("submit has been successful", response_ids);
        },
        error: function (e) {
          console.log("submit has failed", e);
        }
      };

      $("#submitBtn").click(function() {
        var okToSubmit = true;
        $.each(itemsApp.questions(), function(responseID, question) {
          if (!question.isAttempted()) {
            okToSubmit = confirm("One or more questions have not been attempted. Are you sure you want to submit?");
            return false;
          }
        });
        if (okToSubmit) { itemsApp.submit(submitSettings); }
      });
      
      

      //Snippet 4: Validate All Questions Manually
      $("#validateBtn").click(function() {
        $.each(itemsApp.questions(), function(responseID, question) {
          question.validate();
        });
      });
      //trigger an event programmatically
      //question.trigger("changed");
      //



      var itemsApp = LearnosityItems.init(<?php echo $signedRequest; ?>, eventOptions);
    </script>
  </body>
</html>