<?php

include_once 'config.php';

use LearnositySdk\Request\Init;

$request = [
    'reports' => [
        [
            'user_id'     => 'brianmoser',
            'session_id'  => 'AC023456-2C73-44DC-82DA28894FCBC3BF',
            'type'        => 'session-detail-by-question',
            'id'          => 'report-session-detail'
        ],
        [
            'user_id'     => 'brianmoser',
            'session_ids' => [
                'AC023456-2C73-44DC-82DA28894FCBC3BF'
            ],
            'type'        => 'sessions-summary',
            'id'          => 'report-session-summary'
        ]
    ]
];

$Init = new Init('reports', $security, $consumer_secret, $request);
$signedRequest = $Init->generate();

?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <title>Report: Session Detail by Question</title>
    </head>
    <body>
        <div style="width:750px;">
            <h3 class="report-title">Session Summary</h3>
            <span class="learnosity-report" id="report-session-summary"></span>
            <h3 class="report-title">Session Detail</h3>
            <span class="learnosity-report" id="report-session-detail"></span>
        </div>

        <script src="//reports.learnosity.com"></script>
        <script>
            var lrnReports = LearnosityReports.init(<?php echo $signedRequest; ?>);
        </script>
    </body>
</html>