<?php

include_once 'config.php';

use LearnositySdk\Request\Init;
use LearnositySdk\Utils\Uuid;

$request = [
    'user_id'        => 'demo_student',
    'session_id'     => Uuid::generate(),
    'items'          => ['Tut002_Item1', 'Tut002_Item2', 'Tut002_Item3'],
    'rendering_type' => 'assess',
    'state'          => 'initial',
    'type'           => 'submit_practice',
    'activity_id'    => 'demo_activity',
    'name'           => 'The Color Wheel',
    'course_id'      => 'demo_course',
    "config"         => [
                            'ui_style'                   => 'horizontal',
                            "ignore_question_attributes" => [
                                "instant_feedback"
                            ],
                            'configuration' => [
                                'onsubmit_redirect_url'  => 'index.html'
                            ]
                        ]
];


$Init = new Init('items', $security, $consumer_secret, $request);
$signedRequest = $Init->generate();

?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <title>How Color Works</title>
    </head>
    <body>
        <div style="width:750px;">
            <h3 class="item-title">The Color Wheel</h3>
            <div id="learnosity_assess"></div>


        </div>

        <script src="//items.learnosity.com/"></script>
        <script>
            var itemsApp = LearnosityItems.init(<?php echo $signedRequest; ?>);
        </script>
    </body>
</html>